PROC TABULATE DATA = ghpb21 missing noseps;

VAR subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT;
title 'Table B1. Number of Group Health Plans and Total Participants' ;
title2 'by type of insurance and insurance contract status, 2021' ;
title3 'All Plans';
CLASS insurance_type INS3 filingsize / PRELOADFMT;
VAR dup_wgt;
TABLE  all='Total' insurance_type=' ',
	  (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.)) /MISSTEXT='-' box='Type of Insurance Contracts';
RUN;

PROC TABULATE DATA = ghpb21 missing noseps;
where filingsize='1';
VAR subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT;
title 'Table B1. Number of Group Health Plans and Total Participants' ;
title2 'by type of insurance and insurance contract status, 2021' ;
title3 'Plans with 100 or More Participants and Trusts';
CLASS insurance_type INS3 filingsize / PRELOADFMT;
VAR dup_wgt;
TABLE  all='Total' insurance_type=' ',
	  (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.)) /MISSTEXT='-' box='Type of Insurance Contracts';
RUN;

PROC TABULATE DATA = ghpb21 missing noseps;
where filingsize='2';
VAR subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT;
title 'Table B1. Number of Group Health Plans and Total Participants' ;
title2 'by type of insurance and insurance contract status, 2021' ;
title3 'Plans with 100 or More Participants and No Trusts';
CLASS insurance_type INS3 filingsize / PRELOADFMT;
VAR dup_wgt;
TABLE  all='Total' insurance_type=' ',
	  (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.)) /MISSTEXT='-' box='Type of Insurance Contracts';
RUN;

PROC TABULATE DATA = ghpb21 missing noseps;
where filingsize='3';
VAR subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT;
title 'Table B1. Number of Group Health Plans and Total Participants' ;
title2 'by type of insurance and insurance contract status, 2021' ;
title3 'Plans with Fewer Than 100 Participants and Trusts';
CLASS insurance_type INS3 filingsize / PRELOADFMT;
VAR dup_wgt;
TABLE  all='Total' insurance_type=' ',
	  (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.)) /MISSTEXT='-' box='Type of Insurance Contracts';
RUN;
